import pandas as pd

"""
This file is to calculate the gender ratio of the participants

@author: Jonathan van Oudheusden
@date: 2024-01-28

Required files: 
    - prolific_profile_anonym.csv
    
Output files:
    - prints in the terminal
"""

fileParticipantInfo = 'Givenfiles/Data/prolific_profile_anonym.csv'

dfProfile = pd.read_csv(fileParticipantInfo)

count_total = 0
count_women = 0
count_men = 0
count_nonBinary = 0
for index, row in dfProfile.iterrows():
    count_total += 1
    if (row['Gender'] == 'Woman (including Trans Female/Trans Woman)'):
        count_women += 1
    elif (row['Gender'] == 'Man (including Trans Male/Trans Man)'):
        count_men += 1
    else:
        count_nonBinary += 1

print(f"total: {count_total} - woman%: {(count_women / count_total)* 100}  {(count_men / count_total)* 100} nonbinary {(count_nonBinary / count_total)* 100}")

